import React from 'react';
import "./simpleTheme.css";

interface SimpleThemeProps {
  mode?: "light" | "dusky";
}

const SimpleTheme: React.FC<SimpleThemeProps> = ({ mode = "light" }) => {
  const navItems = [
    { name: "Theme A", path: "/annepie/themeA" },
    { name: "Theme B", path: "/annepie/themeB" },
    { name: "Theme C", path: "/annepie/themeC" },
    { name: "Theme D", path: "/annepie/themeD" },
    { name: "Theme E", path: "/annepie/themeE" },
  ];

  return (
    <div className={`simple-theme-container ${mode}`}>
      <header className="simple-header">
        <div className="simple-header-overlay">
          <h1 className="simple-site-title">Annepi.com</h1>
          <nav className="simple-navigation">
            {navItems.map(item => (
              <a key={item.name} href={item.path} className="simple-nav-link">{item.name}</a>
            ))}
          </nav>
        </div>
      </header>

      <div className="simple-body-wrapper">
        <div className="simple-content">
          <aside className="simple-sidebar">
            <p><strong>Path:</strong></p>
            <ul className="simple-sidebar-path">
              <li><a href="#item1">Item 1</a></li>
              <li><a href="#item1a">Item 1a</a></li>
              <li><a href="#item2">Item 2</a></li>
            </ul>
            <p>Simple sidebar notes...</p>
          </aside>

          <main className="simple-main">
            <h2>Simple Theme</h2>
            <p>Clean, minimal, and elegant.</p>

            <div className="simple-decorative-frame">
              <div className="simple-frame-content">
                <p>Content with minimal styling</p>
              </div>
            </div>

            <div className="simple-decorative-frame">
              <div className="simple-frame-content">
                <p>Another content block</p>
              </div>
            </div>
          </main>
        </div>
      </div>
    </div>
  );
};

export default SimpleTheme; 